# Heatmap

Das Programm verwendet zum Parallelisieren SPMD und Threads.

## SPMD

Das Programm läuft mehrfach. Die Prozesse kommunizieren dabei über Nachrichten. Das Test-Programm läuft lediglich auf einem Rechner. Eine rein thread-basierte Parallelisierung mit gemeinsamen Speicher wäre hier performanter.

Es kommt MPI als Cluster-Library zum Einsatz.

## Threads


## Datenparallelisierung

nach PPkonzepte.pdf 3-21

### Datendekomposition

Jeder Bildpunkt kann parallel berechnet werden. 

### Kommunikation

Jeder Bildpunkt muss bei jeder Iteration mit seinen Nachbarn kommunizieren, also müssen die Strukturen bei dem "verteilten Speicher" Modell möglichst gut erhalten bleiben. Bei der threadparallelen Verarbeitung ist besonders darauf zu achten, das der Zugriff auf gemeinse Variable performant funktioniert. Cache Verdrängung ist ein zusätzlicher Bedenkpunkt.

### Agglomeration

Bildpunkte werden zu Teilfeldern zusammengefasst. Jeder Prozessor übernimmt exakt ein Teilfeld. Es wird solange iteriert bis alle Teilfelder fertig sind. Um möglichst wenig Kommunikation an den Kanten zu erzeugen, wird die Matrix schachbrett-artig in Teilfelder geteilt.

Durch

Anzahl der Prozesse in 2. Dimension = sqrt((Anzahl der Prozesse) * (Größe 1. Dimension))/(Größe 2. Dimension))
Anzahl der Prozesse in 1. Dimension = (Anzahl der Prozesse)/(Anzahl der Prozesse in 2. Dimension)

können die Kantenlängen minimiert werden. Dadurch wird der Payload der Nachrichten und folglich die Latenz verringert.

Innerhalb eines Teilfeldes werden die Bildpunkte auf Threads aufgeteilt. Hier ist der Zugriff auf alle Bildpunkte gleich teuer. Zur Synchronisation von maxdiff wird das reduction-Feature von OpenMP genutzt. Dabei hält jeder Thread eine Kopie und nur zum Abschluss muss synchronisiert werden.

### Mapping

Zur Abbildung der Nachbarschaften bietet MPI u.a. kartesische Gitter. Durch Hilfsfunktionen kann leicht mit Nachbarn Daten ausgetauscht werden. Die Funktion `Create_MPI_Cart_Cluster` erlaubt das Neu-Anordnen von Ranks. Dadurch können Nachbarn auch physikalisch nah gekoppelt werden. Da das Programm allerdings nur auf einem Rechner läuft, sind alle Prozesse eng gekoppelt; eine Neu-Anordnung ist dadurch nicht notwending.

## Messungen

### Problemgröße 4096 x 4096

#### Prozesse: 1 

Threads: 48

init: 0.2023320198
iterate 135.5007259846
total: 135.7030580044

Thread: 24

init: 0.2041509151
iterate 135.3141219616
total: 135.5182728767

Threads: 4

init: 0.1982460022
iterate 134.8806080818
total: 135.0788540840

Threads: 1

init: 0.2125899792
iterate 145.0294249058
total: 145.2420148849

#### Prozesse: 4

Threads: 24

init: 0.0553040504
iterate 9.8884358406
total: 9.9437398911

Thread: 12

init: 0.0458610058
iterate 7.0884110928
total: 7.1342720985

Threads: 4

init: 0.0574810505
iterate 10.9555878639
total: 11.0130689144

Threads: 1

init: 0.0585498810
iterate 36.9415891171
total: 37.0001389980

#### Prozesse: 9

Threads: 4

init: 0.0229120255
iterate 8.8880679607
total: 8.9109799862

### Problemgröße 512 x 512

#### Prozesse: 1

Threads: 1

init: 0.0045759678
iterate 2.2183640003
total: 2.2229399681

Threads: 48

init: 0.0045459270
iterate 2.1009421349
total: 2.1054880619

#### Prozesse: 4

Threads: 1

init: 0.0027439594
iterate 0.6688849926
total: 0.6716289520

Threads: 12

init: 0.0018460751
iterate 0.1323008537
total: 0.1341469288

### Problemgröße 32 x 32

### Prozesse: 1

Threads: 1

init: 0.0002450943
iterate 0.0079269409
total: 0.0081720352

Threads: 4

init: 0.0002338886
iterate 0.0097441673
total: 0.0099780560

### Prozesse: 4

Threads: 1

init: 0.0004258156
iterate 0.0035309792
total: 0.0039567947

Threads: 4

init: 0.0004351139
iterate 0.0039939880
total: 0.0044291019
 
## Auswertung

Die Parallelisierung bringt einen 

Eine ungewöhnliche Beobachtung ist, dass bei nur 1. Prozess kein Performanz-Gewinn durch mehrere Threads erzielt wird. 