
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void process_args(int argc, char **argv, int *m, int *n, double *eps, double *delta_t) {
	if ((argc < 3) || (argc > 5)) {
		fprintf(stderr, "Usage: heat <m> <n> [<epsilon> [delta_t]]!\n\n");
		fprintf(stderr, "   <m>       -- X-Size of matrix\n");
		fprintf(stderr, "   <n>       -- Y-Size of matrix\n");
		fprintf(stderr, "   <epsilon> -- accuracy parameter\n");
		fprintf(stderr, "   <delta_t> -- time step\n");
		exit(1);
	}

	/*
	** Erstes und zweites Argument: Größe der Matrix
	*/
	*m = atoi(argv[1]);
	if ((*m < 3) || (*m > 6000)) {
		fprintf(stderr, "Error: size m out of range [3 .. 6000] !\n");
		exit(1);
	}
	*n = atoi(argv[2]);
	if ((*n < 3) || (*n > 6000)) {
		fprintf(stderr, "Error: size n out of range [3 .. 6000] !\n");
		exit(1);
	}
	/*
	** Drittes (optionales) Argument: "Genauigkeitsfaktor" eps
	*/
	if (argc >= 4) {
		*eps = atof(argv[3]);
	}
	if ((*eps <= 0) || (*eps > 0.01)){
		fprintf(stderr, "Error: epsilon must be between 0.0000000001 and 0.01 )\n");
		exit(1);
	}
	/*
	** Viertes (optionales) Argument: delta_t
	*/
	if (argc >= 5) {
		*delta_t = atof(argv[4]);
	}
	if ((*delta_t <= 0) || (*delta_t > 1.0)){
		fprintf(stderr, "Error: delta_t (%f) must be between 0.0000000001 and 1.0\n", *delta_t);
		exit(1);
	}
}