# Heatmap

Das Programm verwendet zum Parallelisieren SPMD und Threads.

## Datendekomposition

Jeder Bildpunkt braucht seine Nachbarn zur iterativen Berechnung, also müssen die Strukturen bei dem "verteilten Speicher" Modell möglichst gut erhalten bleiben. Bei der threadparallelen Verarbeitung ist besonders darauf zu achten, das der Zugriff auf gemeinse Variable performant funktioniert. Cache Verdrängung ist ein zusätzlicher Bedenkpunkt.

## SPMD

Das Programm läuft mehrfach. Die Prozesse kommunizieren dabei über Nachrichten. Das Test-Programm läuft lediglich auf einem Rechner. Eine rein thread-basierte Parallelisierung mit gemeinsamen Speicher wäre hier performanter.

Jede Instanz kann sich selbst eindeutig identifizieren. Dies kann genutzt werden um Datenmengen (gleichmäßig) zuzuordnen. Die Matrix wird schachbrett-artig auf die Prozesse aufgeteilt.

Durch

Anzahl der Prozesse in 2. Dimension = sqrt((Anzahl der Prozesse) * (Größe 1. Dimension))/(Größe 2. Dimension))
Anzahl der Prozesse in 1. Dimension = (Anzahl der Prozesse)/(Anzahl der Prozesse in 2. Dimension)

können die Kantenlängen minimiert werden. Dadurch wird der Payload der Nachrichten und folglich die Latenz verringert.

Es kommt MPI als Cluster-Library zum Einsatz.

Zur Abbildung der Nachbarschaften bietet MPI u.a. kartesische Gitter. Durch Hilfsfunktionen kann leicht mit Nachbarn Daten ausgetauscht werden. Die Funktion `Create_MPI_Cart_Cluster` erlaubt das Neu-Anordnen von Ranks. Dadurch können Nachbarn auch physikalisch nah gekoppelt werden. Da das Programm allerdings nur auf einem Rechner läuft, sind alle Prozesse eng gekoppelt; eine Neu-Anordnung ist dadurch nicht notwending.

## Threads

 

## Messungen

Innere Schleife

4096x4096 

P: 8 T: 2 B: 128

init: 0.0655639172
iterate 26.5077140331
total: 26.5732779503

P: 16 T: 2 B: 128

init: 0.0172390938
iterate 11.4972770214
total: 11.5145161152

P: 32 T: 2 B: 128

init: 0.0220100880
iterate 13.2383890152
total: 13.2603991032

P: 32 disablled OpenMP

init: 0.0144450665
iterate 11.0444979668
total: 11.0589430332

P: 1 48 512

init: 0.2176799774
iterate 127.5701329708
total: 127.7878129482

## Auswertung

OpenMP bringt erstaunlich wenig