#include <mpi.h>

typedef struct {
	int rank;
	int coord0;
	int coord1;
	int start_m;	// first tile to process in X-axis
	int start_n;	// first tile to process in Y-axis
	int end_m;	// last tile to process in X-axis
	int end_n;	// last tile to process in Y-axis
} t_process_info;

// matrix.c
double ** New_Matrix(int m, int n);
void Delete_Matrix(double **matrix);
void Write_Matrix(double **a, int m, int n);
void Init_Matrix(double **a, int m, int n, int init_value);
void Insert_Matrix(double **a, int a_dim0, int a_dim1, int pos_dim0, int pos_dim1, double **b, int b_dim0, int b_dim1, int offset_top, int offset_right, int offset_bottom, int offset_left);
void Insert_Array_In_Matrix(double **a, int a_dim0, int a_dim1, int pos_dim0, int pos_dim1, double *b, int b_dim0, int b_dim1, int offset_top, int offset_right, int offset_bottom, int offset_left);

// args.c
void Process_Args(int argc, char **argv, int *m, int *n, double *eps, double *delta_t);

// mpi_util.c
void Create_MPI_Type_t_process_info(MPI_Datatype *datatype);
void Init_Neighbor_Comm(MPI_Comm cart_comm, MPI_Request *sync_requests, int *matrix_size, int *neighbor_dim0_left, int *neighbor_dim0_right, int *neighbor_dim1_left, int *neighbor_dim1_right, double **dim1_own_edge_values, double **dim1_neighbor_egde_values);
int Sync(MPI_Comm cart_comm, int completion, int *completions, int cart_cluster_size, int *matrix_size, MPI_Request *sync_requests, int neighbor_dim0_left, int neighbor_dim0_right, int neighbor_dim1_left, int neighbor_dim1_right, double **partial_field, double *dim1_own_edge_values, double *dim1_neighbor_egde_values);

// cart.c
void Optimize_Cart_Cluster(int dim0_size, int dim1_size, MPI_Comm comm, int rank, int *pro_per_dim, int *cell_per_pro);
MPI_Comm Create_MPI_Cart_Cluster(MPI_Comm comm, int rank, int *pro_per_dim);

// pi.c
t_process_info Calculate_Process_Info(MPI_Comm cart_comm, int rank, int dim0_size, int dim1_size, int *cell_per_pro);
void Print_Process_Info(t_process_info pi);

// pid0.c
t_process_info* Gather_Process_Info(t_process_info *pi, int rank, int cluster_size, MPI_Comm cart_comm);
void Send_To_Root(MPI_Comm cart_comm, int rank, int dim0_size, int dim1_size, int cart_cluster_size, int *matrix_size, t_process_info *infos, double **partial_field, double **root_field);

// jacobi.c
void Alloc_Partial_Field(int *matrix_size, double ***partial_field, double ***partial_field_clipboard);
void Init_Jacobi(int dim0_size, int dim1_size, int alpha, double *delta_t, double *hx, double *hy, double *hx_square, double *hy_square);
void Init_Edges(int dim0_size, int dim1_size, int *matrix_size, int neighbor_dim0_left, int neighbor_dim0_right, int neighbor_dim1_left, int neighbor_dim1_right, double **partial_field, double **partial_field_clipboard, t_process_info pi);
int Jacobi_Iterate(int neighbor_dim0_left, int neighbor_dim0_right, int neighbor_dim1_left, int neighbor_dim1_right, double alpha, double delta_t, double eps, double hx_square, double hy_square, t_process_info pi, double ***partial_field, double ***partial_field_clipboard);