#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int main(int argc, char **argv) {
    int test_amount = argc > 1 ? atoi(argv[1]) : 2000000;
    int message = 1337;
    double start, end;
    int size, pid;
    int count;
    MPI_Status status;

    MPI_Init(&argc, &argv);
    
    MPI_Comm_rank(MPI_COMM_WORLD, &pid);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    if (size < 2 || pid != 0 && pid != 1 || test_amount < 1) {
        goto exit;
    }

    printf("Process %d: Running %d send/receive!\n\n", pid, test_amount);

    start = MPI_Wtime();
    for (count = 0; count < test_amount; count++) {        
        if (pid == 0) {
            MPI_Send((void *)(&message), 1, MPI_INT, 1, 0, MPI_COMM_WORLD);
        } else {
            int recv;
            MPI_Recv(&recv, 1, MPI_INT, 0, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        }
    }
    end = MPI_Wtime();

    printf("Process %d total of %fs with avg. of %fs.\n", pid, 
        (end - start), ((end - start) / (double)test_amount));

exit:
    MPI_Finalize();
    return 0;
}
