#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <mpi.h> 
#include <sys/time.h>

/* HILFSFUNKTIONEN ******************************************************* */

/*
** Allokiere ein 2D-Array mit m * n Elementen (m Zeilen mit n Spalten).
** Also so etwas wie ``new double[m][n]'' ...
*/
double ** New_Matrix(int m, int n)
{
	double **res;
	double *array;
	int i;

	/*
	** Ergebnis ist ein 1D-Array mit Zeigern auf die Zeilen des 2D-Arrays
	*/
	res = (double **)malloc(sizeof(double *) * m);
	if (res == NULL)
		return NULL;

	/*
	** Das eigentliche Array wird aus Effizienzgr�nden in einem St�ck
	** allokiert. Das entspricht dem Speicher-Layout, den es auch bei
	** statischer Allokation h�tte.
	*/
	array = (double *)malloc(sizeof(double) * m * n);
	if (array == NULL)
		return NULL;

	/*
	** Jeder Zeilen-Zeiger wird nun mit dem richtigen Wert besetzt.
	** (Zeile i beginnt bei Eintrag i*n)
	*/
	for (i = 0; i < m; i++) {
		res[i] = &array[i * n];
	}
	return res;
}

/*
** Freigabe eines 2D-Arrays.
*/
void Delete_Matrix(double **matrix)
{
	free(matrix[0]);
	free(matrix);
}

/*
** Gibt die mxn-Matrix 'a' in die Datei 'Matrix.txt' aus.
*/
void Write_Matrix(double **a, int m, int n)
{
	int i, j;
	FILE *f;

	/* Datei zum Schreiben �ffnen */
	f = fopen("Matrix.txt", "w");
	if (f == NULL) {
		fprintf(stderr, "Cannot open file 'Matrix.txt' for writing!");
		exit(1);
	}

	/* Gr��e der Matrix schreiben */
	fprintf(f, "%d\n", m);	
	fprintf(f, "%d\n\n", n);

	/* Matrix-Elemente zeilenweise in die Datei schreiben */
	for (i = 0; i < m; i++) {
		for (j = 0; j < n; j++) {
			fprintf(f, "%.10lf\n", a[i][j]);
		}
		fprintf(f, "\n");
	}

	/* Datei schlie�en */
	fclose(f);
}


/*
** Matrix initialisieren
*/
void Init_Matrix(double **a, int m, int n, int init_value) {
	int i,j;
	for (i=0; i<m; i++) {
		for (j=0; j<n; j++) {
			a[i][j] = init_value;
		}
	}
}

void Insert_Matrix(double **a, int a_dim0, int a_dim1, int pos_dim0, int pos_dim1, double **b, int b_dim0, int b_dim1, int offset_dim0_left, int offset_dim0_right, int offset_dim1_left, int offset_dim1_right) {
	int i,j;
	for(i=0; i < b_dim0 - offset_dim0_left - offset_dim0_right; i++) {
		for(j=0; j < b_dim1 - offset_dim1_left - offset_dim1_right; j++) {
			a[pos_dim0 + i][pos_dim1 + j] = b[offset_dim0_left + i][offset_dim1_right + j];
		}
	}
}

void Insert_Array_In_Matrix(double **a, int a_dim0, int a_dim1, int pos_dim0, int pos_dim1, double *b, int b_dim0, int b_dim1, int offset_dim0_left, int offset_dim0_right, int offset_dim1_left, int offset_dim1_right) {
	int i,j;
	for(i=0; i < b_dim0 - offset_dim0_left - offset_dim0_right; i++) {
		for(j=0; j < b_dim1 - offset_dim1_left - offset_dim1_right; j++) {
			a[pos_dim0 + i][pos_dim1 + j] = b[(offset_dim0_left + i) * b_dim1 + offset_dim1_right + j];
		}
	}
}