#include <mpi.h> 
#include <stdio.h>
#include <stdlib.h>
#include "project.h"

t_process_info Calculate_Process_Info(MPI_Comm cart_comm, int rank, int dim0_size, int dim1_size, int *cell_per_pro) {
	t_process_info pi;
	int coord[2];
	if(MPI_Cart_coords(cart_comm, rank, 2, coord)) {
		fprintf(stderr, "Cannot get coordinates\n");		
		exit(1);
	}

	// calculate own field using coord
	pi.start_m = coord[0] * cell_per_pro[0];
	pi.end_m = (coord[0]+1)*cell_per_pro[0] -1;
	pi.start_n = coord[1] * cell_per_pro[1];
	pi.end_n = (coord[1]+1) * cell_per_pro[1] -1;
	if(pi.end_m > dim0_size - 1) {
		pi.end_m = dim0_size - 1;
	}
	if(pi.end_n > dim1_size - 1) {
		pi.end_n = dim1_size - 1;
	}
	pi.coord0 = coord[0];
	pi.coord1 = coord[1];
	pi.rank = rank;

	return pi;
}

void Print_Process_Info(t_process_info pi) {
	printf("rank: %d->(%d,%d) from (%d, %d) to (%d,%d)\n", 
		pi.rank,
		pi.coord0,
		pi.coord1,
		pi.start_m,
		pi.start_n,
		pi.end_m,
		pi.end_n
	);
}