
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void Process_Args(int argc, char **argv, int *num_threads, int *m, int *n, double *eps, double *delta_t) {
	if ((argc < 4) || (argc > 6)) {
		fprintf(stderr, "Usage: main <num_threads> <m> <n> [<epsilon> [delta_t]]!\n\n");
		fprintf(stderr, "   <num_threads>       -- Number of threads\n");
		fprintf(stderr, "   <m>       -- X-Size of matrix\n");
		fprintf(stderr, "   <n>       -- Y-Size of matrix\n");
		fprintf(stderr, "   <epsilon> -- accuracy parameter\n");
		fprintf(stderr, "   <delta_t> -- time step\n");
		exit(1);
	}

	*num_threads = atoi(argv[1]);

	/*
	** Erstes und zweites Argument: Größe der Matrix
	*/
	*m = atoi(argv[2]);
	if ((*m < 3) || (*m > 6000)) {
		fprintf(stderr, "Error: size m out of range [3 .. 6000] !\n");
		exit(1);
	}
	*n = atoi(argv[3]);
	if ((*n < 3) || (*n > 6000)) {
		fprintf(stderr, "Error: size n out of range [3 .. 6000] !\n");
		exit(1);
	}
	/*
	** Drittes (optionales) Argument: "Genauigkeitsfaktor" eps
	*/
	if (argc >= 5) {
		*eps = atof(argv[4]);
	}
	if ((*eps <= 0) || (*eps > 0.01)){
		fprintf(stderr, "Error: epsilon must be between 0.0000000001 and 0.01 )\n");
		exit(1);
	}
	/*
	** Viertes (optionales) Argument: delta_t
	*/
	if (argc >= 6) {
		*delta_t = atof(argv[5]);
	}
	if ((*delta_t <= 0) || (*delta_t > 1.0)){
		fprintf(stderr, "Error: delta_t (%f) must be between 0.0000000001 and 1.0\n", *delta_t);
		exit(1);
	}
}