#include <mpi.h> 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "project.h"

void Optimize_Cart_Cluster(int dim0_size, int dim1_size, MPI_Comm comm, int rank, int *pro_per_dim, int *cell_per_pro) {
	int num_p;
	float float_pro_per_dim0, float_pro_per_dim1;

	if(MPI_Comm_size(comm, &num_p)) {
		fprintf(stderr, "Cannot fetch size of cluster\n");		
		exit(1);
	}

	if(rank == 0) {
		printf("number of processes: %d\n", num_p);
	}

	float_pro_per_dim1 = sqrt((float)(num_p*dim0_size)/dim1_size);
	float_pro_per_dim0 = num_p/float_pro_per_dim1;
	float_pro_per_dim1 = floor(float_pro_per_dim1);
	float_pro_per_dim0 = floor(float_pro_per_dim0);		// try ceil
	pro_per_dim[0] = (int)float_pro_per_dim0;
	pro_per_dim[1] = (int)float_pro_per_dim1;

	cell_per_pro[0] = ceil(dim0_size/(float)pro_per_dim[1]);
	cell_per_pro[1] = ceil(dim1_size/(float)pro_per_dim[0]);

	if(rank==0) {
		printf("dim0: %d dim1: %d\n", pro_per_dim[0], pro_per_dim[1]);
		printf("size per pro: %dx%d\n", cell_per_pro[0], cell_per_pro[1]);	
	}
}

MPI_Comm Create_MPI_Cart_Cluster(MPI_Comm comm, int rank, int *pro_per_dim) {
	MPI_Comm cart_comm;
	int periods[] = {0,0};	// edges are not connected
	
	// no reorder
	if(MPI_Cart_create(comm, 2, pro_per_dim, periods, 0, &cart_comm)) {
		fprintf(stderr, "Cannot create topology\n");		
		exit(1);
	}

	if(cart_comm == MPI_COMM_NULL) {
		printf("process %d not in use. exiting...\n", rank);
		// finalize is neccessary otherwise MPI crashes
		MPI_Finalize();
		exit(0);
	}

	return cart_comm;
}