## Thinks to consider:
1.  For me, imports in the wsdl (and bpel) file are black magic
2.  46.101.159.46.wsdl is obtained from the BPM Labs website
3.  In 46.101.159.46.wsdl the definition of "InventoryCallbackService"
    was modified.
    As it is an port of the "local" service, the address was set to
    "http://localhost:8080/ode/processes/InventoryCallbackService".
    It is similar to the service definitions in the other bpel file
    and has to be compatible with requiremets of ode ("...ode/processes/...").
4.  I've recycled the "storeOrderDetailInput" message as input for this process.
    It already contains all required information.
5.  "checkAvaAsyn" is the most critical part of the process:
    1.    XslTransformation is required to transform the list of products
            from "products/product/productId" to
            "checkAvailabiltyAsync/productId". "bpel:doXslTransform" 
            and ProductId.xsl do the transformation.
    2.    **!!! I decided to write the "orderId" into
            "checkAvailablityAsync/customerId"** as it is suppoed to be a unique
            idenifier for correlation and "customerId" is not unique if the same
            customer orders twice.
    3.    "checkAvailablityAsync/callbackUrl" is set as the URL to the
            "InventoryCallbackService" from outside of the Docker container.
            **!!! At each start up, the respective port binding for 8080 has to
            updated.**
    4.    Correlation is required in "checkAvaAsyn" and "onFinish"
6.  The if statement employs a xpath expression counting products in a stat
    not equal to "available"
7.  Further insight [here](http://infocenter.activevos.com/infocenter/ActiveVOS/v92/index.jsp?topic=/com.activee.bpep.doc/html/UG16-6-1.html)